//
//  MPBatchProcessing.h
//  MPServices
//
//  Created by Oleksii Dykan on 7/21/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPAbstractBatchSettingsController.h"

typedef CGImageRef(^MPBatchImageProcessBlock)(NSDictionary *processOptions, NSDictionary **imageProperties, NSError **error);
typedef void(^MPUnsupportedRawHandler)(NSArray *unsupportedRAWUrls);
typedef void(^MPBatchBuyInAppBlock)(void);

extern NSString *const MPBatchImageProcessKeyImageUrl;
extern NSString *const MPBatchImageProcessKeyImageSize;
extern NSString *const MPBatchImageProcessKeyIsThumbnail;
extern NSString *const MPBatchImageProcessKeyShouldProcess;
extern NSString *const MPBatchImageProcessKeyColorSpaceType;
extern NSString *const MPBatchImageProcessKeyImageProcessingSettings;

typedef NS_ENUM(NSUInteger, MPBatchColorSpaceType) {
    MPBatchColorSpaceTypeSRGB,
    MPBatchColorSpaceTypeAdobeRGB,
    MPBatchColorSpaceTypeProPhotoRGB,
};

@interface MPBatchProcessing : NSObject

@property (nonatomic, assign) BOOL needsInApp;
@property (nonatomic, assign) BOOL needsColorSpace;
@property (nonatomic, copy) MPUnsupportedRawHandler unsupportedRawHandler;
@property (nonatomic, copy) MPBatchImageProcessBlock imageProcessBlock;
@property (nonatomic, copy) MPBatchBuyInAppBlock buyInAppBlock;
@property (nonatomic, strong) MPAbstractBatchSettingsController *batchSettingsController;

+ (MPBatchProcessing *)sharedBatchProcessing;

+ (void)setNeedsInApp:(BOOL)needsInApp;
+ (void)setNeedsColorSpace:(BOOL)needsColorSpace;
+ (void)setUnsupportedRawHandler:(MPUnsupportedRawHandler)unsupportedRawHandler;
+ (void)setImageProcessBlock:(MPBatchImageProcessBlock)imageProcessBlock;
+ (void)showBatchProcessingIfNeededWithCompletionHandler:(void(^)())completionHandler;

- (BOOL)isProductPurchased;

@end
